#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

typedef struct Node {
    int64_t key;
    int count;
    struct Node* next;
} Node;

#define HASH_SIZE 131071

Node* hash[HASH_SIZE];

unsigned int h(int64_t x) {
    return (unsigned int)((x ^ (x >> 32)) % HASH_SIZE);
}

void add(int64_t key) {
    unsigned int idx = h(key);
    Node* cur = hash[idx];
    while (cur) {
        if (cur->key == key) {
            cur->count++;
            return;
        }
        cur = cur->next;
    }
    Node* n = (Node*)malloc(sizeof(Node));
    n->key = key;
    n->count = 1;
    n->next = hash[idx];
    hash[idx] = n;
}

int64_t sum_pairs() {
    int64_t sum = 0;
    for (int i = 0; i < HASH_SIZE; i++) {
        Node* cur = hash[i];
        while (cur) {
            int64_t k = cur->count;
            sum += k * (k - 1);
            cur = cur->next;
        }
    }
    return sum;
}

void free_map() {
    for (int i = 0; i < HASH_SIZE; i++) {
        Node* cur = hash[i];
        while (cur) {
            Node* tmp = cur;
            cur = cur->next;
            free(tmp);
        }
        hash[i] = NULL;
    }
}

int main() {
    int N;
    scanf("%d", &N);

    int64_t* S = (int64_t*)malloc(N * sizeof(int64_t));
    int64_t* D = (int64_t*)malloc(N * sizeof(int64_t));

    for (int i = 0; i < N; i++) {
        int64_t x, y;
        scanf("%lld %lld", &x, &y);
        S[i] = x + y;
        D[i] = x - y;
    }

    for (int i = 0; i < N; i++) add(S[i]);
    int64_t ans = sum_pairs();
    free_map();

    for (int i = 0; i < N; i++) add(D[i]);
    ans += sum_pairs();
    free_map();

    printf("%lld\n", ans);

    free(S);
    free(D);
    return 0;
}